/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.dlcm.model.preingest.Deposit;
import ch.dlcm.tools.common.DLCMTools;
import ch.dlcm.tools.common.DepositUploader;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"load"})
public class DepositLoad
extends DLCMTools
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DepositLoad.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;

    public DepositLoad(StandaloneRestClientTool restClientTool) {
        super(restClientTool);
    }

    public void run(String ... arg0) throws Exception {
        String prefix = "[Deposit Load]";
        if (!this.loadFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[Deposit Load]", (Object)this.loadFolder);
            int count = 0;
            for (Path depositId : FileTool.scanFolder((Path)Paths.get(this.loadFolder, new String[0]), x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                if (Files.isHidden(depositId)) continue;
                Deposit deposit = this.findDeposit(depositId.getFileName().toString());
                if (deposit == null) {
                    log.error("{} Deposit {} does not exist", (Object)"[Deposit Load]", (Object)depositId.getFileName());
                    continue;
                }
                if (deposit.getStatus() != Deposit.DepositStatus.IN_PROGRESS) {
                    log.warn("{} Deposit {} not ready for loading: status={}", new Object[]{"[Deposit Load]", depositId.getFileName(), deposit.getStatus()});
                    continue;
                }
                log.info("{} Deposit loading for {} started", (Object)"[Deposit Load]", (Object)depositId.getFileName());
                DepositUploader depositUploader = new DepositUploader(this.restClientTool, this.preIngestUrl, this.licenseId);
                depositUploader.loadDepositDatafiles("[Deposit Load]", deposit, depositId, false);
                log.info("{} Deposit loading for {} completed", (Object)"[Deposit Load]", (Object)depositId.getFileName());
            }
            log.info("{} Deposit loading end {} : {} processed deposit(s)", new Object[]{"[Deposit Load]", this.loadFolder, ++count});
        }
    }
}

