/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools;

import ch.dlcm.model.preingest.Deposit;
import ch.dlcm.tools.common.DLCMTools;
import ch.dlcm.tools.common.DepositPurger;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"purge"})
public class DepositPurge
extends DLCMTools
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DepositPurge.class);
    @Value(value="${dlcm.load}")
    private String loadFolder;
    @Value(value="${dlcm.relative-locations}")
    private String[] relativeLocationList;

    public DepositPurge(StandaloneRestClientTool restClientTool) {
        super(restClientTool);
    }

    public void run(String ... arg0) throws Exception {
        String prefix = "[Deposit Purge]";
        if (!this.loadFolder.isEmpty()) {
            log.info("{} Scanning folder : {}", (Object)"[Deposit Purge]", (Object)this.loadFolder);
            int count = 0;
            int fileCount = 0;
            for (Path depositId : FileTool.scanFolder((Path)Paths.get(this.loadFolder, new String[0]), x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
                if (Files.isHidden(depositId)) continue;
                Deposit deposit = this.findDeposit(depositId.getFileName().toString());
                if (deposit == null) {
                    log.error("{} Deposit {} does not exist", (Object)"[Deposit Purge]", (Object)depositId.getFileName());
                    continue;
                }
                if (deposit.getStatus() != Deposit.DepositStatus.IN_PROGRESS) {
                    log.warn("{} Deposit {} not ready for purging: status={}", new Object[]{"[Deposit Purge]", depositId.getFileName(), deposit.getStatus()});
                    continue;
                }
                DepositPurger depositPurger = new DepositPurger(this.restClientTool, this.preIngestUrl);
                List listFolder = depositPurger.listFolders("[Deposit Purge]", depositId.getFileName().toString());
                log.info("{} Deposit purge for {} started", (Object)"[Deposit Purge]", (Object)depositId.getFileName());
                for (String relativeLocation : this.relativeLocationList) {
                    log.info("{} Deposit purging for {}: {}", new Object[]{"[Deposit Purge]", depositId.getFileName(), relativeLocation});
                    List folderCandidates = listFolder.stream().filter(f -> f.startsWith(relativeLocation)).collect(Collectors.toList());
                    for (String folder : folderCandidates) {
                        fileCount += depositPurger.deleteDepositDatafiles("[Deposit Purge]", deposit.getResId(), folder);
                    }
                }
                log.info("{} Deposit purge for {} completed", (Object)"[Deposit Purge]", (Object)depositId.getFileName());
            }
            log.info("{} Deposit purging end {} : {} processed deposit(s), {} purged files", new Object[]{"[Deposit Purge]", this.loadFolder, ++count, fileCount});
        }
    }
}

