/*
 * Decompiled with CFR 0.152.
 */
package ch.dlcm.tools.common;

import ch.dlcm.model.oais.ArchiveContainer;
import ch.dlcm.tools.common.DLCMTools;
import ch.unige.solidify.util.FileTool;
import ch.unige.solidify.util.StandaloneRestClientTool;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIPUploader
extends DLCMTools {
    private static final Logger log = LoggerFactory.getLogger(AIPUploader.class);

    public AIPUploader(StandaloneRestClientTool restClientTool, String arcStorageUrl) {
        super(restClientTool);
        this.archivalStorageUrl = arcStorageUrl;
    }

    public void importAIP(String organizationalUnitId, Path folder) {
        String prefix = "[OrganizationalUnit=" + organizationalUnitId + " AIP] ";
        log.info("{} Scanning AIP folder: {}", (Object)prefix, (Object)folder);
        int count = 0;
        for (Path aipType : FileTool.scanFolder((Path)folder, x$0 -> Files.isDirectory(x$0, new LinkOption[0]))) {
            ArchiveContainer aipContainer = this.getAipContainer(aipType.getFileName().toString());
            if (aipContainer == null) continue;
            for (Path d : this.scanAll(aipType)) {
                ++count;
                log.info("{} Importing {}", (Object)prefix, (Object)d);
                if (this.sendAIP(prefix, organizationalUnitId, d, aipContainer) != null) continue;
                log.error("{} Cannot import AIP {}", (Object)prefix, (Object)d);
            }
        }
        log.info("{} Importing end {} : {} uploaded AIP file(s)", new Object[]{prefix, folder, count});
    }

    private ArchiveContainer getAipContainer(String aipCoontainer) {
        if (aipCoontainer.equalsIgnoreCase(ArchiveContainer.ZIP.toString().replace("_", ""))) {
            return ArchiveContainer.ZIP;
        }
        if (aipCoontainer.equalsIgnoreCase(ArchiveContainer.BAG_IT.toString().replace("_", ""))) {
            return ArchiveContainer.BAG_IT;
        }
        return null;
    }
}

